/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!*********************************************************!*\
  !*** ./resources/js/admin/parts/settings/statistics.js ***!
  \*********************************************************/
(function ($) {
  "use strict";

  var style = getComputedStyle(document.body);
  var primaryColor = style.getPropertyValue('--primary');
  function updateToDatabase(idString) {
    $.post(adminPanelPrefix + '/settings/personalization/statistics/sort', {
      items: idString
    }, function (result) {
      showToast('success', result.title, result.msg);
    }).fail(function (err) {
      showToast('error', 'Error', '');
    });
  }
  function setSortable(target) {
    if (target.length) {
      target.sortable({
        group: 'no-drop',
        handle: '.move-icon',
        axis: "y",
        update: function update(e, ui) {
          var sortData = target.sortable('toArray', {
            attribute: 'data-id'
          });
          updateToDatabase(sortData.join(','));
        }
      });
    }
  }
  var target = $('.draggable-lists');
  setSortable(target);
  $('body').on('change', '#display_default_statisticsSwitch', function (e) {
    e.preventDefault();
    var $input = $('.js-custom-statistics');
    if (this.checked) {
      $input.addClass('d-none');
    } else {
      $input.removeClass('d-none');
    }
  });
  function getModalData(path) {
    loadingSwl();
    $.get(path, function (result) {
      if (result.code === 200) {
        Swal.fire({
          html: result.html,
          showCancelButton: false,
          showConfirmButton: false,
          customClass: {
            content: 'p-0 text-left'
          },
          width: '36rem',
          onOpen: function onOpen() {
            $(".colorpickerinput").colorpicker({
              format: 'hex',
              component: '.input-group-append'
            });
          }
        });
      }
    });
  }
  $('body').on('click', '.js-add-statistics, .js-edit-statistic', function () {
    var path = $(this).attr('data-path');
    getModalData(path);
  });
  $('body').on('change', '.js-statistic-locale', function () {
    var form = $(this).closest('#addStatisticItemForm');
    var path = form.attr('data-action');
    path = path.replaceAll('updateItem', 'editItem');
    path = path + "?locale=" + $(this).val();
    getModalData(path);
  });
  $('body').on('click', '.js-save-statistic', function () {
    var $this = $(this);
    var $form = $('#addStatisticItemForm');
    var data = serializeObjectByTag($form);
    var action = $form.attr('data-action');
    $this.addClass('loadingbar primary').prop('disabled', true);
    $form.find('input').removeClass('is-invalid');
    $form.find('textarea').removeClass('is-invalid');
    $.post(action, data, function (result) {
      if (result && result.code === 200) {
        //window.location.reload();
        Swal.fire({
          icon: 'success',
          html: '<h3 class="font-20 text-center text-dark-blue py-25">' + saveSuccessLang + '</h3>',
          showConfirmButton: false,
          width: '25rem'
        });
        setTimeout(function () {
          window.location.reload();
        }, 500);
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;
      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = $form.find('.js-ajax-' + key);
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  });
})(jQuery);
/******/ })()
;